<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Varaha Techsols - Robotic Tank Inspections</title>
  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Font Awesome for Icons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
  <!-- Custom CSS -->
  <link href="assets/css/styles.css" rel="stylesheet">
  <!-- Swiper CSS (slider for hero) -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.css">

  <!-- Favicon and touch icons -->
  <link rel="icon" type="image/png" sizes="32x32" href="assets/images/favicon.png">
  <link rel="apple-touch-icon" sizes="180x180" href="assets/images/favicon.png">
  <meta name="msapplication-TileColor" content="#834C89">

  <!-- Social / SEO meta tags - update `og:url` and absolute image URLs to match your production domain -->
  <meta name="description" content="Varaha Techsols provides autonomous robotic tank inspection services that deliver high-resolution data, zero downtime, and audit-ready reporting to help operators stay compliant and efficient.">
  <meta name="keywords" content="robotic tank inspection, on-stream inspection, API 653, EEMUA 159, predictive maintenance, autonomous inspection, Varaha Techsols">
  <link rel="canonical" href="https://yourdomain.com/">

  <!-- Open Graph / Facebook -->
  <meta property="og:title" content="Varaha Techsols - Robotic Tank Inspections">
  <meta property="og:description" content="Autonomous, on‑stream robotic inspections that keep tanks operational while delivering high‑resolution, audit‑ready data for predictive maintenance and compliance.">
  <meta property="og:type" content="website">
  <!-- Update og:url to your live page URL (must be absolute) -->
  <meta property="og:url" content="https://yourdomain.com/">
  <!-- Prefer an absolute URL for og:image in production; this uses the local image path as a fallback -->
  <meta property="og:image" content="assets/images/banner5.jpg">
  <meta property="og:image:alt" content="Varaha Techsols robotic inspection platform in action">

  <!-- Twitter Card -->
  <meta name="twitter:card" content="summary_large_image">
  <meta name="twitter:site" content="@YourTwitterHandle">
  <meta name="twitter:creator" content="@YourTwitterHandle">
  <meta name="twitter:title" content="Varaha Techsols - Robotic Tank Inspections">
  <meta name="twitter:description" content="Autonomous, on‑stream robotic inspections that keep tanks operational while delivering high‑resolution, audit‑ready data for predictive maintenance and compliance.">
  <meta name="twitter:image" content="assets/images/banner5.jpg">


</head>
<body>
  <!-- Navbar -->
  <nav class="navbar navbar-expand-lg">
    <div class="container-fluid">
      <!-- Logo -->
      <a class="navbar-brand" href="#">
        <img src="assets/images/logo_final.png" alt="Varaha Techsols Logo">
      </a>
      <!-- Menu -->
      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
      </button>
      <div class="collapse navbar-collapse justify-content-center" id="navbarNav">
        <ul class="navbar-nav">
          <li class="nav-item">
            <a class="nav-link active" href="index.php">Home</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="about.php">About Us</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="services.php">Services</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="contact.php">Contact Us</a>
          </li>
        </ul>
      </div>
      <!-- Contact Number -->
      <div class="contact-number d-none d-lg-block">
        <i class="fas fa-phone-alt"></i> +1-800-123-4567 
      </div>
    </div>
  </nav>